package JSci.chemistry.periodictable;

/**
* A class representing boron.
* @version 1.5
* @author Mark Hale
*/
public final class Boron extends NonMetal {
        /**
        * Constructs boron.
        */
        public Boron() {}
        /**
        * Returns the atomic number.
        * @return 5
        */
        public int atomicNumber() {return 5;}
        /**
        * Returns the mass number.
        * @return 11
        */
        public int massNumber() {return 11;}
        /**
        * Returns the electronegativity.
        * @return 2.04
        */
        public double electronegativity() {return 2.04;}
        /**
        * Returns the covalent radius.
        * @return 0.88
        */
        public double covalentRadius() {return 0.88;}
        /**
        * Returns the atomic radius.
        * @return 1.17
        */
        public double atomicRadius() {return 1.17;}
        /**
        * Returns the melting point.
        * @return 2300
        */
        public double meltingPoint() {return 2300;}
        /**
        * Returns the boiling point.
        * @return 4275
        */
        public double boilingPoint() {return 4275;}
        /**
        * Returns the density (293K).
        * @return 2.34
        */
        public double density() {return 2.34;}
        /**
        * Returns the specific heat.
        * @return 1.02
        */
        public double specificHeat() {return 1.02;}
        /**
        * Returns the electrical conductivity.
        * @return 1.0e-6
        */
        public double electricalConductivity() {return 1.0e-6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.270
        */
        public double thermalConductivity() {return 0.270;}
        /**
        * Returns the chemical symbol.
        * @return B
        */
        public String toString() {
                return new String("B");
        }
}

