package JSci.chemistry.periodictable;

/**
* A class representing bromine.
* @version 1.5
* @author Mark Hale
*/
public final class Bromine extends Halogen {
        /**
        * Constructs bromine.
        */
        public Bromine() {}
        /**
        * Returns the atomic number.
        * @return 35
        */
        public int atomicNumber() {return 35;}
        /**
        * Returns the mass number.
        * @return 80
        */
        public int massNumber() {return 80;}
        /**
        * Returns the electronegativity.
        * @return 2.96
        */
        public double electronegativity() {return 2.96;}
        /**
        * Returns the covalent radius.
        * @return 1.142
        */
        public double covalentRadius() {return 1.142;}
        /**
        * Returns the atomic radius.
        * @return 1.12
        */
        public double atomicRadius() {return 1.12;}
        /**
        * Returns the melting point.
        * @return 265.9
        */
        public double meltingPoint() {return 265.9;}
        /**
        * Returns the boiling point.
        * @return 332.25
        */
        public double boilingPoint() {return 332.25;}
        /**
        * Returns the density (293K).
        * @return 3.119
        */
        public double density() {return 3.119;}
        /**
        * Returns the specific heat.
        * @return 0.473
        */
        public double specificHeat() {return 0.473;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.00122
        */
        public double thermalConductivity() {return 0.00122;}
        /**
        * Returns the chemical symbol.
        * @return Br
        */
        public String toString() {
                return new String("Br");
        }
}

