package JSci.chemistry.periodictable;

/**
* A class representing caesium.
* @version 1.5
* @author Mark Hale
*/
public final class Caesium extends AlkaliMetal {
        /**
        * Constructs caesium.
        */
        public Caesium() {}
        /**
        * Returns the atomic number.
        * @return 55
        */
        public int atomicNumber() {return 55;}
        /**
        * Returns the mass number.
        * @return 133
        */
        public int massNumber() {return 133;}
        /**
        * Returns the electronegativity.
        * @return 0.79
        */
        public double electronegativity() {return 0.79;}
        /**
        * Returns the covalent radius.
        * @return 2.35
        */
        public double covalentRadius() {return 2.35;}
        /**
        * Returns the atomic radius.
        * @return 3.34
        */
        public double atomicRadius() {return 3.34;}
        /**
        * Returns the melting point.
        * @return 301.55
        */
        public double meltingPoint() {return 301.55;}
        /**
        * Returns the boiling point.
        * @return 944
        */
        public double boilingPoint() {return 944;}
        /**
        * Returns the density (293K).
        * @return 1.873
        */
        public double density() {return 1.873;}
        /**
        * Returns the specific heat.
        * @return 0.24
        */
        public double specificHeat() {return 0.24;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0489e6
        */
        public double electricalConductivity() {return 0.0489e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.359
        */
        public double thermalConductivity() {return 0.359;}
        /**
        * Returns the chemical symbol.
        * @return Cs
        */
        public String toString() {
                return new String("Cs");
        }
}

