package JSci.chemistry.periodictable;

/**
* A class representing californium.
* @version 1.5
* @author Mark Hale
*/
public final class Californium extends RareEarthMetal {
        /**
        * Constructs californium.
        */
        public Californium() {}
        /**
        * Returns the atomic number.
        * @return 98
        */
        public int atomicNumber() {return 98;}
        /**
        * Returns the mass number.
        * @return 251
        */
        public int massNumber() {return 251;}
        /**
        * Returns the electronegativity.
        * @return 1.3
        */
        public double electronegativity() {return 1.3;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 900
        */
        public double meltingPoint() {return 900;}
        /**
        * Returns the boiling point.
        * @return Unknown
        */
        public double boilingPoint() {return Double.NaN;}
        /**
        * Returns the density (293K).
        * @return Unknown
        */
        public double density() {return Double.NaN;}
        /**
        * Returns the specific heat.
        * @return Unknown
        */
        public double specificHeat() {return Double.NaN;}
        /**
        * Returns the electrical conductivity.
        * @return Unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.1
        */
        public double thermalConductivity() {return 0.1;}
        /**
        * Returns the chemical symbol.
        * @return Cf
        */
        public String toString() {
                return new String("Cf");
        }
}

