package JSci.chemistry.periodictable;

/**
* A class representing carbon.
* @version 1.5
* @author Mark Hale
*/
public final class Carbon extends NonMetal {
        /**
        * Constructs carbon.
        */
        public Carbon() {}
        /**
        * Returns the atomic number.
        * @return 6
        */
        public int atomicNumber() {return 6;}
        /**
        * Returns the mass number.
        * @return 12
        */
        public int massNumber() {return 12;}
        /**
        * Returns the electronegativity.
        * @return 2.55
        */
        public double electronegativity() {return 2.55;}
        /**
        * Returns the covalent radius.
        * @return 0.77
        */
        public double covalentRadius() {return 0.77;}
        /**
        * Returns the atomic radius.
        * @return 0.91
        */
        public double atomicRadius() {return 0.91;}
        /**
        * Returns the melting point.
        * @return 3550
        */
        public double meltingPoint() {return 3550;}
        /**
        * Returns the boiling point.
        * @return 4827
        */
        public double boilingPoint() {return 4827;}
        /**
        * Returns the density (293K).
        * @return 2.62
        */
        public double density() {return 2.62;}
        /**
        * Returns the specific heat.
        * @return 0.71
        */
        public double specificHeat() {return 0.71;}
        /**
        * Returns the electrical conductivity.
        * @return 0.61e9
        */
        public double electricalConductivity() {return 0.61e9;}
        /**
        * Returns the thermal conductivity.
        * @return 1.29
        */
        public double thermalConductivity() {return 1.29;}
        /**
        * Returns the chemical symbol.
        * @return C
        */
        public String toString() {
                return new String("C");
        }
}

