package JSci.chemistry.periodictable;

/**
* A class representing cerium.
* @version 1.5
* @author Mark Hale
*/
public final class Cerium extends RareEarthMetal {
        /**
        * Constructs cerium.
        */
        public Cerium() {}
        /**
        * Returns the atomic number.
        * @return 58
        */
        public int atomicNumber() {return 58;}
        /**
        * Returns the mass number.
        * @return 140
        */
        public int massNumber() {return 140;}
        /**
        * Returns the electronegativity.
        * @return 1.12
        */
        public double electronegativity() {return 1.12;}
        /**
        * Returns the covalent radius.
        * @return 1.65
        */
        public double covalentRadius() {return 1.65;}
        /**
        * Returns the atomic radius.
        * @return 2.70
        */
        public double atomicRadius() {return 2.70;}
        /**
        * Returns the melting point.
        * @return 1071
        */
        public double meltingPoint() {return 1071;}
        /**
        * Returns the boiling point.
        * @return 3699
        */
        public double boilingPoint() {return 3699;}
        /**
        * Returns the density (293K).
        * @return 6.78
        */
        public double density() {return 6.78;}
        /**
        * Returns the specific heat.
        * @return 0.19
        */
        public double specificHeat() {return 0.19;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0115e6
        */
        public double electricalConductivity() {return 0.0115e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.114
        */
        public double thermalConductivity() {return 0.114;}
        /**
        * Returns the chemical symbol.
        * @return Ce
        */
        public String toString() {
                return new String("Ce");
        }
}
