package JSci.chemistry.periodictable;

/**
* A class representing chromium.
* @version 1.5
* @author Mark Hale
*/
public final class Chromium extends TransitionMetal {
        /**
        * Constructs chromium.
        */
        public Chromium() {}
        /**
        * Returns the atomic number.
        * @return 24
        */
        public int atomicNumber() {return 24;}
        /**
        * Returns the mass number.
        * @return 52
        */
        public int massNumber() {return 52;}
        /**
        * Returns the electronegativity.
        * @return 1.66
        */
        public double electronegativity() {return 1.66;}
        /**
        * Returns the covalent radius.
        * @return 1.17
        */
        public double covalentRadius() {return 1.17;}
        /**
        * Returns the atomic radius.
        * @return 1.85
        */
        public double atomicRadius() {return 1.85;}
        /**
        * Returns the melting point.
        * @return 2130
        */
        public double meltingPoint() {return 2130;}
        /**
        * Returns the boiling point.
        * @return 2945
        */
        public double boilingPoint() {return 2945;}
        /**
        * Returns the density (293K).
        * @return 7.19
        */
        public double density() {return 7.19;}
        /**
        * Returns the specific heat.
        * @return 0.45
        */
        public double specificHeat() {return 0.45;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0774e6
        */
        public double electricalConductivity() {return 0.0774e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.937
        */
        public double thermalConductivity() {return 0.937;}
        /**
        * Returns the chemical symbol.
        * @return Cr
        */
        public String toString() {
                return new String("Cr");
        }
}

