package JSci.chemistry.periodictable;

/**
* A class representing cobalt.
* @version 1.5
* @author Mark Hale
*/
public final class Cobalt extends TransitionMetal {
        /**
        * Constructs cobalt.
        */
        public Cobalt() {}
        /**
        * Returns the atomic number.
        * @return 27
        */
        public int atomicNumber() {return 27;}
        /**
        * Returns the mass number.
        * @return 59
        */
        public int massNumber() {return 59;}
        /**
        * Returns the electronegativity.
        * @return 1.88
        */
        public double electronegativity() {return 1.88;}
        /**
        * Returns the covalent radius.
        * @return 1.16
        */
        public double covalentRadius() {return 1.16;}
        /**
        * Returns the atomic radius.
        * @return 1.67
        */
        public double atomicRadius() {return 1.67;}
        /**
        * Returns the melting point.
        * @return 1768
        */
        public double meltingPoint() {return 1768;}
        /**
        * Returns the boiling point.
        * @return 3201
        */
        public double boilingPoint() {return 3201;}
        /**
        * Returns the density (293K).
        * @return 8.9
        */
        public double density() {return 8.9;}
        /**
        * Returns the specific heat.
        * @return 0.42
        */
        public double specificHeat() {return 0.42;}
        /**
        * Returns the electrical conductivity.
        * @return 0.172e6
        */
        public double electricalConductivity() {return 0.172e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.00
        */
        public double thermalConductivity() {return 1.00;}
        /**
        * Returns the chemical symbol.
        * @return Co
        */
        public String toString() {
                return new String("Co");
        }
}

