package JSci.chemistry.periodictable;

/**
* A class representing copper.
* @version 1.5
* @author Mark Hale
*/
public final class Copper extends TransitionMetal {
        /**
        * Constructs copper.
        */
        public Copper() {}
        /**
        * Returns the atomic number.
        * @return 29
        */
        public int atomicNumber() {return 29;}
        /**
        * Returns the mass number.
        * @return 63
        */
        public int massNumber() {return 63;}
        /**
        * Returns the electronegativity.
        * @return 1.90
        */
        public double electronegativity() {return 1.90;}
        /**
        * Returns the covalent radius.
        * @return 1.17
        */
        public double covalentRadius() {return 1.17;}
        /**
        * Returns the atomic radius.
        * @return 1.57
        */
        public double atomicRadius() {return 1.57;}
        /**
        * Returns the melting point.
        * @return 1357.6
        */
        public double meltingPoint() {return 1357.6;}
        /**
        * Returns the boiling point.
        * @return 2836
        */
        public double boilingPoint() {return 2836;}
        /**
        * Returns the density (293K).
        * @return 8.96
        */
        public double density() {return 8.96;}
        /**
        * Returns the specific heat.
        * @return 0.38
        */
        public double specificHeat() {return 0.38;}
        /**
        * Returns the electrical conductivity.
        * @return 0.596e6
        */
        public double electricalConductivity() {return 0.596e6;}
        /**
        * Returns the thermal conductivity.
        * @return 4.01
        */
        public double thermalConductivity() {return 4.01;}
        /**
        * Returns the chemical symbol.
        * @return Cu
        */
        public String toString() {
                return new String("Cu");
        }
}

