package JSci.chemistry.periodictable;

/**
* A class representing europium.
* @version 1.5
* @author Mark Hale
*/
public final class Europium extends RareEarthMetal {
        /**
        * Constructs europium.
        */
        public Europium() {}
        /**
        * Returns the atomic number.
        * @return 63
        */
        public int atomicNumber() {return 63;}
        /**
        * Returns the mass number.
        * @return 152
        */
        public int massNumber() {return 152;}
        /**
        * Returns the electronegativity.
        * @return 1.2
        */
        public double electronegativity() {return 1.2;}
        /**
        * Returns the covalent radius.
        * @return 1.85
        */
        public double covalentRadius() {return 1.85;}
        /**
        * Returns the atomic radius.
        * @return 2.56
        */
        public double atomicRadius() {return 2.56;}
        /**
        * Returns the melting point.
        * @return 1090
        */
        public double meltingPoint() {return 1090;}
        /**
        * Returns the boiling point.
        * @return 1870
        */
        public double boilingPoint() {return 1870;}
        /**
        * Returns the density (293K).
        * @return 5.259
        */
        public double density() {return 5.259;}
        /**
        * Returns the specific heat.
        * @return 0.18
        */
        public double specificHeat() {return 0.18;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0112e6
        */
        public double electricalConductivity() {return 0.0112e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.139
        */
        public double thermalConductivity() {return 0.139;}
        /**
        * Returns the chemical symbol.
        * @return Eu
        */
        public String toString() {
                return new String("Eu");
        }
}
