package JSci.chemistry.periodictable;

/**
* A class representing francium.
* @version 1.5
* @author Mark Hale
*/
public final class Francium extends AlkaliMetal {
        /**
        * Constructs francium.
        */
        public Francium() {}
        /**
        * Returns the atomic number.
        * @return 87
        */
        public int atomicNumber() {return 87;}
        /**
        * Returns the mass number.
        * @return 223
        */
        public int massNumber() {return 223;}
        /**
        * Returns the electronegativity.
        * @return 0.7
        */
        public double electronegativity() {return 0.7;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 300
        */
        public double meltingPoint() {return 300;}
        /**
        * Returns the boiling point.
        * @return 950
        */
        public double boilingPoint() {return 950;}
        /**
        * Returns the density (293K).
        * @return Unknown
        */
        public double density() {return Double.NaN;}
        /**
        * Returns the specific heat.
        * @return Unknown
        */
        public double specificHeat() {return Double.NaN;}
        /**
        * Returns the electrical conductivity.
        * @return 0.03e6
        */
        public double electricalConductivity() {return 0.03e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.15
        */
        public double thermalConductivity() {return 0.15;}
        /**
        * Returns the chemical symbol.
        * @return Fr
        */
        public String toString() {
                return new String("Fr");
        }
}

