package JSci.chemistry.periodictable;

/**
* A class representing gallium.
* @version 1.5
* @author Mark Hale
*/
public final class Gallium extends Metal {
        /**
        * Constructs gallium.
        */
        public Gallium() {}
        /**
        * Returns the atomic number.
        * @return 31
        */
        public int atomicNumber() {return 31;}
        /**
        * Returns the mass number.
        * @return 70
        */
        public int massNumber() {return 70;}
        /**
        * Returns the electronegativity.
        * @return 1.81
        */
        public double electronegativity() {return 1.81;}
        /**
        * Returns the covalent radius.
        * @return 1.25
        */
        public double covalentRadius() {return 1.25;}
        /**
        * Returns the atomic radius.
        * @return 1.81
        */
        public double atomicRadius() {return 1.81;}
        /**
        * Returns the melting point.
        * @return 302.9
        */
        public double meltingPoint() {return 302.9;}
        /**
        * Returns the boiling point.
        * @return 2478.0
        */
        public double boilingPoint() {return 2478.0;}
        /**
        * Returns the density (293K).
        * @return 5.907
        */
        public double density() {return 5.907;}
        /**
        * Returns the specific heat.
        * @return 0.37
        */
        public double specificHeat() {return 0.37;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0678e6
        */
        public double electricalConductivity() {return 0.0678e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.406
        */
        public double thermalConductivity() {return 0.406;}
        /**
        * Returns the chemical symbol.
        * @return Ga
        */
        public String toString() {
                return new String("Ga");
        }
}

