package JSci.chemistry.periodictable;

/**
* A class representing germanium.
* @version 1.5
* @author Mark Hale
*/
public final class Germanium extends Metal {
        /**
        * Constructs germanium.
        */
        public Germanium() {}
        /**
        * Returns the atomic number.
        * @return 32
        */
        public int atomicNumber() {return 32;}
        /**
        * Returns the mass number.
        * @return 72
        */
        public int massNumber() {return 72;}
        /**
        * Returns the electronegativity.
        * @return 2.01
        */
        public double electronegativity() {return 2.01;}
        /**
        * Returns the covalent radius.
        * @return 1.22
        */
        public double covalentRadius() {return 1.22;}
        /**
        * Returns the atomic radius.
        * @return 1.52
        */
        public double atomicRadius() {return 1.52;}
        /**
        * Returns the melting point.
        * @return 1210.4
        */
        public double meltingPoint() {return 1210.4;}
        /**
        * Returns the boiling point.
        * @return 3107.0
        */
        public double boilingPoint() {return 3107.0;}
        /**
        * Returns the density (293K).
        * @return 5.323
        */
        public double density() {return 5.323;}
        /**
        * Returns the specific heat.
        * @return 0.32
        */
        public double specificHeat() {return 0.32;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0145
        */
        public double electricalConductivity() {return 0.0145;}
        /**
        * Returns the thermal conductivity.
        * @return 0.599
        */
        public double thermalConductivity() {return 0.599;}
        /**
        * Returns the chemical symbol.
        * @return Ge
        */
        public String toString() {
                return new String("Ge");
        }
}

