package JSci.chemistry.periodictable;

/**
* A class representing holmium.
* @version 1.5
* @author Mark Hale
*/
public final class Holmium extends RareEarthMetal {
        /**
        * Constructs holmium.
        */
        public Holmium() {}
        /**
        * Returns the atomic number.
        * @return 67
        */
        public int atomicNumber() {return 67;}
        /**
        * Returns the mass number.
        * @return 165
        */
        public int massNumber() {return 165;}
        /**
        * Returns the electronegativity.
        * @return 1.23
        */
        public double electronegativity() {return 1.23;}
        /**
        * Returns the covalent radius.
        * @return 1.58
        */
        public double covalentRadius() {return 1.58;}
        /**
        * Returns the atomic radius.
        * @return 2.47
        */
        public double atomicRadius() {return 2.47;}
        /**
        * Returns the melting point.
        * @return 1743.0
        */
        public double meltingPoint() {return 1743.0;}
        /**
        * Returns the boiling point.
        * @return 2968.0
        */
        public double boilingPoint() {return 2968.0;}
        /**
        * Returns the density (293K).
        * @return 8.80
        */
        public double density() {return 8.80;}
        /**
        * Returns the specific heat.
        * @return 0.16
        */
        public double specificHeat() {return 0.16;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0124e6
        */
        public double electricalConductivity() {return 0.0124e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.162
        */
        public double thermalConductivity() {return 0.162;}
        /**
        * Returns the chemical symbol.
        * @return Ho
        */
        public String toString() {
                return new String("Ho");
        }
}

