package JSci.chemistry.periodictable;

/**
* A class representing hydrogen.
* @version 1.5
* @author Mark Hale
*/
public final class Hydrogen extends NonMetal {
        /**
        * Constructs hydrogen.
        */
        public Hydrogen() {}
        /**
        * Returns the atomic number.
        * @return 1
        */
        public int atomicNumber() {return 1;}
        /**
        * Returns the mass number.
        * @return 1
        */
        public int massNumber() {return 1;}
        /**
        * Returns the electronegativity.
        * @return 2.20
        */
        public double electronegativity() {return 2.20;}
        /**
        * Returns the covalent radius.
        * @return 0.371
        */
        public double covalentRadius() {return 0.371;}
        /**
        * Returns the atomic radius.
        * @return 0.79
        */
        public double atomicRadius() {return 0.79;}
        /**
        * Returns the melting point.
        * @return 14.025
        */
        public double meltingPoint() {return 14.025;}
        /**
        * Returns the boiling point.
        * @return 20.268
        */
        public double boilingPoint() {return 20.268;}
        /**
        * Returns the density (293K).
        * @return 0.0000899
        */
        public double density() {return 0.0000899;}
        /**
        * Returns the specific heat.
        * @return 14.304
        */
        public double specificHeat() {return 14.304;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.001815
        */
        public double thermalConductivity() {return 0.001815;}
        /**
        * Returns the chemical symbol.
        * @return H
        */
        public String toString() {
                return new String("H");
        }
}

