package JSci.chemistry.periodictable;

/**
* A class representing indium.
* @version 1.5
* @author Mark Hale
*/
public final class Indium extends Metal {
        /**
        * Constructs indium.
        */
        public Indium() {}
        /**
        * Returns the atomic number.
        * @return 49
        */
        public int atomicNumber() {return 49;}
        /**
        * Returns the mass number.
        * @return 115
        */
        public int massNumber() {return 115;}
        /**
        * Returns the electronegativity.
        * @return 1.78
        */
        public double electronegativity() {return 1.78;}
        /**
        * Returns the covalent radius.
        * @return 1.50
        */
        public double covalentRadius() {return 1.50;}
        /**
        * Returns the atomic radius.
        * @return 2.00
        */
        public double atomicRadius() {return 2.00;}
        /**
        * Returns the melting point.
        * @return 429.76
        */
        public double meltingPoint() {return 429.76;}
        /**
        * Returns the boiling point.
        * @return 2346.0
        */
        public double boilingPoint() {return 2346.0;}
        /**
        * Returns the density (293K).
        * @return 7.31
        */
        public double density() {return 7.31;}
        /**
        * Returns the specific heat.
        * @return 0.23
        */
        public double specificHeat() {return 0.23;}
        /**
        * Returns the electrical conductivity.
        * @return 0.116e6
        */
        public double electricalConductivity() {return 0.116e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.816
        */
        public double thermalConductivity() {return 0.816;}
        /**
        * Returns the chemical symbol.
        * @return In
        */
        public String toString() {
                return new String("In");
        }
}

