package JSci.chemistry.periodictable;

/**
* A class representing iridium.
* @version 1.5
* @author Mark Hale
*/
public final class Iridium extends TransitionMetal {
        /**
        * Constructs iridium.
        */
        public Iridium() {}
        /**
        * Returns the atomic number.
        * @return 77
        */
        public int atomicNumber() {return 77;}
        /**
        * Returns the mass number.
        * @return 192
        */
        public int massNumber() {return 192;}
        /**
        * Returns the electronegativity.
        * @return 2.20
        */
        public double electronegativity() {return 2.20;}
        /**
        * Returns the covalent radius.
        * @return 1.27
        */
        public double covalentRadius() {return 1.27;}
        /**
        * Returns the atomic radius.
        * @return 1.87
        */
        public double atomicRadius() {return 1.87;}
        /**
        * Returns the melting point.
        * @return 2716.0
        */
        public double meltingPoint() {return 2716.0;}
        /**
        * Returns the boiling point.
        * @return 4701.0
        */
        public double boilingPoint() {return 4701.0;}
        /**
        * Returns the density (293K).
        * @return 22.42
        */
        public double density() {return 22.42;}
        /**
        * Returns the specific heat.
        * @return 0.130
        */
        public double specificHeat() {return 0.130;}
        /**
        * Returns the electrical conductivity.
        * @return 0.197e6
        */
        public double electricalConductivity() {return 0.197e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.47
        */
        public double thermalConductivity() {return 1.47;}
        /**
        * Returns the chemical symbol.
        * @return Ir
        */
        public String toString() {
                return new String("Ir");
        }
}

