package JSci.chemistry.periodictable;

/**
* A class representing iron.
* @version 1.5
* @author Mark Hale
*/
public final class Iron extends TransitionMetal {
        /**
        * Constructs iron.
        */
        public Iron() {}
        /**
        * Returns the atomic number.
        * @return 26
        */
        public int atomicNumber() {return 26;}
        /**
        * Returns the mass number.
        * @return 56
        */
        public int massNumber() {return 56;}
        /**
        * Returns the electronegativity.
        * @return 1.83
        */
        public double electronegativity() {return 1.83;}
        /**
        * Returns the covalent radius.
        * @return 1.165
        */
        public double covalentRadius() {return 1.165;}
        /**
        * Returns the atomic radius.
        * @return 1.72
        */
        public double atomicRadius() {return 1.72;}
        /**
        * Returns the melting point.
        * @return 1809.0
        */
        public double meltingPoint() {return 1809.0;}
        /**
        * Returns the boiling point.
        * @return 3135.0
        */
        public double boilingPoint() {return 3135.0;}
        /**
        * Returns the density (293K).
        * @return 7.86
        */
        public double density() {return 7.86;}
        /**
        * Returns the specific heat.
        * @return 0.44
        */
        public double specificHeat() {return 0.44;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0993e6
        */
        public double electricalConductivity() {return 0.0993e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.802
        */
        public double thermalConductivity() {return 0.802;}
        /**
        * Returns the chemical symbol.
        * @return Fe
        */
        public String toString() {
                return new String("Fe");
        }
}

