package JSci.chemistry.periodictable;

/**
* A class representing manganese.
* @version 1.5
* @author Mark Hale
*/
public final class Manganese extends TransitionMetal {
        /**
        * Constructs manganese.
        */
        public Manganese() {}
        /**
        * Returns the atomic number.
        * @return 25
        */
        public int atomicNumber() {return 25;}
        /**
        * Returns the mass number.
        * @return 55
        */
        public int massNumber() {return 55;}
        /**
        * Returns the electronegativity.
        * @return 1.55
        */
        public double electronegativity() {return 1.55;}
        /**
        * Returns the covalent radius.
        * @return 1.17
        */
        public double covalentRadius() {return 1.17;}
        /**
        * Returns the atomic radius.
        * @return 1.79
        */
        public double atomicRadius() {return 1.79;}
        /**
        * Returns the melting point.
        * @return 1517.0
        */
        public double meltingPoint() {return 1517.0;}
        /**
        * Returns the boiling point.
        * @return 2335.0
        */
        public double boilingPoint() {return 2335.0;}
        /**
        * Returns the density (293K).
        * @return 7.43
        */
        public double density() {return 7.43;}
        /**
        * Returns the specific heat.
        * @return 0.48
        */
        public double specificHeat() {return 0.48;}
        /**
        * Returns the electrical conductivity.
        * @return 0.00695e6
        */
        public double electricalConductivity() {return 0.00695e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0782
        */
        public double thermalConductivity() {return 0.0782;}
        /**
        * Returns the chemical symbol.
        * @return Mn
        */
        public String toString() {
                return new String("Mn");
        }
}

