package JSci.chemistry.periodictable;

/**
* A class representing mercury.
* @version 1.5
* @author Mark Hale
*/
public final class Mercury extends TransitionMetal {
        /**
        * Constructs mercury.
        */
        public Mercury() {}
        /**
        * Returns the atomic number.
        * @return 80
        */
        public int atomicNumber() {return 80;}
        /**
        * Returns the mass number.
        * @return 201
        */
        public int massNumber() {return 201;}
        /**
        * Returns the electronegativity.
        * @return 2.00
        */
        public double electronegativity() {return 2.00;}
        /**
        * Returns the covalent radius.
        * @return 1.44
        */
        public double covalentRadius() {return 1.44;}
        /**
        * Returns the atomic radius.
        * @return 1.76
        */
        public double atomicRadius() {return 1.76;}
        /**
        * Returns the melting point.
        * @return 234.28
        */
        public double meltingPoint() {return 234.28;}
        /**
        * Returns the boiling point.
        * @return 630.0
        */
        public double boilingPoint() {return 630.0;}
        /**
        * Returns the density (293K).
        * @return 13.546
        */
        public double density() {return 13.546;}
        /**
        * Returns the specific heat.
        * @return 0.139
        */
        public double specificHeat() {return 0.139;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0104e6
        */
        public double electricalConductivity() {return 0.0104e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0834
        */
        public double thermalConductivity() {return 0.0834;}
        /**
        * Returns the chemical symbol.
        * @return Hg
        */
        public String toString() {
                return new String("Hg");
        }
}

