package JSci.chemistry.periodictable;

/**
* A class representing neodymium.
* @version 1.5
* @author Mark Hale
*/
public final class Neodymium extends RareEarthMetal {
        /**
        * Constructs neodymium.
        */
        public Neodymium() {}
        /**
        * Returns the atomic number.
        * @return 60
        */
        public int atomicNumber() {return 60;}
        /**
        * Returns the mass number.
        * @return 144
        */
        public int massNumber() {return 144;}
        /**
        * Returns the electronegativity.
        * @return 1.14
        */
        public double electronegativity() {return 1.14;}
        /**
        * Returns the covalent radius.
        * @return 1.64
        */
        public double covalentRadius() {return 1.64;}
        /**
        * Returns the atomic radius.
        * @return 2.64
        */
        public double atomicRadius() {return 2.64;}
        /**
        * Returns the melting point.
        * @return 1289.0
        */
        public double meltingPoint() {return 1289.0;}
        /**
        * Returns the boiling point.
        * @return 3341.0
        */
        public double boilingPoint() {return 3341.0;}
        /**
        * Returns the density (293K).
        * @return 7.0
        */
        public double density() {return 7.0;}
        /**
        * Returns the specific heat.
        * @return 0.19
        */
        public double specificHeat() {return 0.19;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0157e6
        */
        public double electricalConductivity() {return 0.0157e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.165
        */
        public double thermalConductivity() {return 0.165;}
        /**
        * Returns the chemical symbol.
        * @return Nd
        */
        public String toString() {
                return new String("Nd");
        }
}

