package JSci.chemistry.periodictable;

/**
* A class representing neon.
* @version 1.5
* @author Mark Hale
*/
public final class Neon extends NobleGas {
        /**
        * Constructs neon.
        */
        public Neon() {}
        /**
        * Returns the atomic number.
        * @return 10
        */
        public int atomicNumber() {return 10;}
        /**
        * Returns the mass number.
        * @return 20
        */
        public int massNumber() {return 20;}
        /**
        * Returns the electronegativity.
        * @return 0.0
        */
        public double electronegativity() {return 0.0;}
        /**
        * Returns the covalent radius.
        * @return 0.71
        */
        public double covalentRadius() {return 0.71;}
        /**
        * Returns the atomic radius.
        * @return 0.51
        */
        public double atomicRadius() {return 0.51;}
        /**
        * Returns the melting point.
        * @return 24.553
        */
        public double meltingPoint() {return 24.553;}
        /**
        * Returns the boiling point.
        * @return 27.096
        */
        public double boilingPoint() {return 27.096;}
        /**
        * Returns the density (293K).
        * @return 0.000901
        */
        public double density() {return 0.000901;}
        /**
        * Returns the specific heat.
        * @return 0.904
        */
        public double specificHeat() {return 0.904;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.000493
        */
        public double thermalConductivity() {return 0.000493;}
        /**
        * Returns the chemical symbol.
        * @return Ne
        */
        public String toString() {
                return new String("Ne");
        }
}

