package JSci.chemistry.periodictable;

/**
* A class representing neptunium.
* @version 1.5
* @author Mark Hale
*/
public final class Neptunium extends RareEarthMetal {
        /**
        * Constructs neptunium.
        */
        public Neptunium() {}
        /**
        * Returns the atomic number.
        * @return 93
        */
        public int atomicNumber() {return 93;}
        /**
        * Returns the mass number.
        * @return 237
        */
        public int massNumber() {return 237;}
        /**
        * Returns the electronegativity.
        * @return 1.36
        */
        public double electronegativity() {return 1.36;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 910.0
        */
        public double meltingPoint() {return 910.0;}
        /**
        * Returns the boiling point.
        * @return Unknown
        */
        public double boilingPoint() {return Double.NaN;}
        /**
        * Returns the density (293K).
        * @return 20.45
        */
        public double density() {return 20.45;}
        /**
        * Returns the specific heat.
        * @return 0.12
        */
        public double specificHeat() {return 0.12;}
        /**
        * Returns the electrical conductivity.
        * @return 0.00822e6
        */
        public double electricalConductivity() {return 0.00822e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.063
        */
        public double thermalConductivity() {return 0.063;}
        /**
        * Returns the chemical symbol.
        * @return Np
        */
        public String toString() {
                return new String("Np");
        }
}

