package JSci.chemistry.periodictable;

/**
* A class representing nickel.
* @version 1.5
* @author Mark Hale
*/
public final class Nickel extends TransitionMetal {
        /**
        * Constructs nickel.
        */
        public Nickel() {}
        /**
        * Returns the atomic number.
        * @return 28
        */
        public int atomicNumber() {return 28;}
        /**
        * Returns the mass number.
        * @return 59
        */
        public int massNumber() {return 59;}
        /**
        * Returns the electronegativity.
        * @return 1.91
        */
        public double electronegativity() {return 1.91;}
        /**
        * Returns the covalent radius.
        * @return 1.15
        */
        public double covalentRadius() {return 1.15;}
        /**
        * Atomic radius.
        * @return 1.62
        */
        public double atomicRadius() {return 1.62;}
        /**
        * Returns the melting point.
        * @return 1726.0
        */
        public double meltingPoint() {return 1726.0;}
        /**
        * Returns the boiling point.
        * @return 3187.0
        */
        public double boilingPoint() {return 3187.0;}
        /**
        * Returns the density (293K).
        * @return 8.90
        */
        public double density() {return 8.90;}
        /**
        * Returns the specific heat.
        * @return 0.44
        */
        public double specificHeat() {return 0.44;}
        /**
        * Returns the electrical conductivity.
        * @return 0.143e6
        */
        public double electricalConductivity() {return 0.143e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.907
        */
        public double thermalConductivity() {return 0.907;}
        /**
        * Returns the chemical symbol.
        * @return Ni
        */
        public String toString() {
                return new String("Ni");
        }
}

