package JSci.chemistry.periodictable;

/**
* A class representing oxygen.
* @version 1.5
* @author Mark Hale
*/
public final class Oxygen extends NonMetal {
        /**
        * Constructs oxygen.
        */
        public Oxygen() {}
        /**
        * Returns the atomic number.
        * @return 8
        */
        public int atomicNumber() {return 8;}
        /**
        * Returns the mass number.
        * @return 16
        */
        public int massNumber() {return 16;}
        /**
        * Returns the electronegativity.
        * @return 3.44
        */
        public double electronegativity() {return 3.44;}
        /**
        * Returns the covalent radius.
        * @return 0.66
        */
        public double covalentRadius() {return 0.66;}
        /**
        * Returns the atomic radius.
        * @return 0.65
        */
        public double atomicRadius() {return 0.65;}
        /**
        * Returns the melting point.
        * @return 50.35
        */
        public double meltingPoint() {return 50.35;}
        /**
        * Returns the boiling point.
        * @return 90.13
        */
        public double boilingPoint() {return 90.13;}
        /**
        * Returns the density (293K).
        * @return 0.001429
        */
        public double density() {return 0.001429;}
        /**
        * Returns the specific heat.
        * @return 0.92
        */
        public double specificHeat() {return 0.92;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0002674
        */
        public double thermalConductivity() {return 0.0002674;}
        /**
        * Returns the chemical symbol.
        * @return O
        */
        public String toString() {
                return new String("O");
        }
}

