package JSci.chemistry.periodictable;

/**
* A class representing palladium.
* @version 1.5
* @author Mark Hale
*/
public final class Palladium extends TransitionMetal {
        /**
        * Constructs palladium.
        */
        public Palladium() {}
        /**
        * Returns the atomic number.
        * @return 46
        */
        public int atomicNumber() {return 46;}
        /**
        * Returns the mass number.
        * @return 106
        */
        public int massNumber() {return 106;}
        /**
        * Returns the electronegativity.
        * @return 2.20
        */
        public double electronegativity() {return 2.20;}
        /**
        * Returns the covalent radius.
        * @return 1.28
        */
        public double covalentRadius() {return 1.28;}
        /**
        * Returns the atomic radius.
        * @return 1.79
        */
        public double atomicRadius() {return 1.79;}
        /**
        * Returns the melting point.
        * @return 1825.0
        */
        public double meltingPoint() {return 1825.0;}
        /**
        * Returns the boiling point.
        * @return 3237.0
        */
        public double boilingPoint() {return 3237.0;}
        /**
        * Returns the density (293K).
        * @return 12.02
        */
        public double density() {return 12.02;}
        /**
        * Returns the specific heat.
        * @return 0.24
        */
        public double specificHeat() {return 0.24;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0950e6
        */
        public double electricalConductivity() {return 0.0950e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.718
        */
        public double thermalConductivity() {return 0.718;}
        /**
        * Returns the chemical symbol.
        * @return Pd
        */
        public String toString() {
                return new String("Pd");
        }
}

