package JSci.chemistry.periodictable;

/**
* A class representing plutonium.
* @version 1.5
* @author Mark Hale
*/
public final class Plutonium extends RareEarthMetal {
        /**
        * Constructs plutonium.
        */
        public Plutonium() {}
        /**
        * Returns the atomic number.
        * @return 94
        */
        public int atomicNumber() {return 94;}
        /**
        * Returns the mass number.
        * @return 242
        */
        public int massNumber() {return 242;}
        /**
        * Returns the electronegativity.
        * @return 1.28
        */
        public double electronegativity() {return 1.28;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 913.0
        */
        public double meltingPoint() {return 913.0;}
        /**
        * Returns the boiling point.
        * @return 3503.0
        */
        public double boilingPoint() {return 3503.0;}
        /**
        * Returns the density (293K).
        * @return 19.8
        */
        public double density() {return 19.8;}
        /**
        * Returns the specific heat.
        * @return 0.13
        */
        public double specificHeat() {return 0.13;}
        /**
        * Returns the electrical conductivity.
        * @return 0.00666e6
        */
        public double electricalConductivity() {return 0.00666e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0674
        */
        public double thermalConductivity() {return 0.0674;}
        /**
        * Returns the chemical symbol.
        * @return Pu
        */
        public String toString() {
                return new String("Pu");
        }
}

