package JSci.chemistry.periodictable;

/**
* A class representing potassium.
* @version 1.5
* @author Mark Hale
*/
public final class Potassium extends AlkaliMetal {
        /**
        * Constructs potassium.
        */
        public Potassium() {}
        /**
        * Returns the atomic number.
        * @return 19
        */
        public int atomicNumber() {return 19;}
        /**
        * Returns the mass number.
        * @return 39
        */
        public int massNumber() {return 39;}
        /**
        * Returns the electronegativity.
        * @return 0.82
        */
        public double electronegativity() {return 0.82;}
        /**
        * Returns the covalent radius.
        * @return 2.025
        */
        public double covalentRadius() {return 2.025;}
        /**
        * Returns the atomic radius.
        * @return 2.77
        */
        public double atomicRadius() {return 2.77;}
        /**
        * Returns the melting point.
        * @return 336.35
        */
        public double meltingPoint() {return 336.35;}
        /**
        * Returns the boiling point.
        * @return 1032.0
        */
        public double boilingPoint() {return 1032.0;}
        /**
        * Returns the density (293K).
        * @return 0.862
        */
        public double density() {return 0.862;}
        /**
        * Returns the specific heat.
        * @return 0.75
        */
        public double specificHeat() {return 0.75;}
        /**
        * Returns the electrical conductivity.
        * @return 0.139e6
        */
        public double electricalConductivity() {return 0.139e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.024
        */
        public double thermalConductivity() {return 1.024;}
        /**
        * Returns the chemical symbol.
        * @return K
        */
        public String toString() {
                return new String("K");
        }
}

