package JSci.chemistry.periodictable;

/**
* A class representing praseodymium.
* @version 1.5
* @author Mark Hale
*/
public final class Praseodymium extends RareEarthMetal {
        /**
        * Constructs praseodymium.
        */
        public Praseodymium() {}
        /**
        * Returns the atomic number.
        * @return 59
        */
        public int atomicNumber() {return 59;}
        /**
        * Returns the mass number.
        * @return 141
        */
        public int massNumber() {return 141;}
        /**
        * Returns the electronegativity.
        * @return 1.13
        */
        public double electronegativity() {return 1.13;}
        /**
        * Returns the covalent radius.
        * @return 1.65
        */
        public double covalentRadius() {return 1.65;}
        /**
        * Returns the atomic radius.
        * @return 2.67
        */
        public double atomicRadius() {return 2.67;}
        /**
        * Returns the melting point.
        * @return 1204.0
        */
        public double meltingPoint() {return 1204.0;}
        /**
        * Returns the boiling point.
        * @return 3785.0
        */
        public double boilingPoint() {return 3785.0;}
        /**
        * Returns the density (293K).
        * @return 6.77
        */
        public double density() {return 6.77;}
        /**
        * Returns the specific heat.
        * @return 0.19
        */
        public double specificHeat() {return 0.19;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0148e6
        */
        public double electricalConductivity() {return 0.0148e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.125
        */
        public double thermalConductivity() {return 0.125;}
        /**
        * Returns the chemical symbol.
        * @return Pr
        */
        public String toString() {
                return new String("Pr");
        }
}

