package JSci.chemistry.periodictable;

/**
* A class representing radium.
* @version 1.5
* @author Mark Hale
*/
public final class Radium extends AlkaliEarthMetal {
        /**
        * Constructs radium.
        */
        public Radium() {}
        /**
        * Returns the atomic number.
        * @return 88
        */
        public int atomicNumber() {return 88;}
        /**
        * Returns the mass number.
        * @return 226
        */
        public int massNumber() {return 226;}
        /**
        * Returns the electronegativity.
        * @return 0.9
        */
        public double electronegativity() {return 0.9;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 973.0
        */
        public double meltingPoint() {return 973.0;}
        /**
        * Returns the boiling point.
        * @return 1809.0
        */
        public double boilingPoint() {return 1809.0;}
        /**
        * Returns the density (293K).
        * @return 5.0
        */
        public double density() {return 5.0;}
        /**
        * Returns the specific heat.
        * @return 0.12
        */
        public double specificHeat() {return 0.12;}
        /**
        * Returns the electrical conductivity.
        * @return Unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.186
        */
        public double thermalConductivity() {return 0.186;}
        /**
        * Returns the chemical symbol.
        * @return Ra
        */
        public String toString() {
                return new String("Ra");
        }
}

