package JSci.chemistry.periodictable;

/**
* A class representing radon.
* @version 1.5
* @author Mark Hale
*/
public final class Radon extends NobleGas {
        /**
        * Constructs radon.
        */
        public Radon() {}
        /**
        * Returns the atomic number.
        * @return 86
        */
        public int atomicNumber() {return 86;}
        /**
        * Returns the mass number.
        * @return 222
        */
        public int massNumber() {return 222;}
        /**
        * Returns the electronegativity.
        * @return 0.0
        */
        public double electronegativity() {return 0.0;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return 1.34
        */
        public double atomicRadius() {return 1.34;}
        /**
        * Returns the melting point.
        * @return 202.0
        */
        public double meltingPoint() {return 202.0;}
        /**
        * Returns the boiling point.
        * @return 211.0
        */
        public double boilingPoint() {return 211.0;}
        /**
        * Returns the density (293K).
        * @return 0.00973
        */
        public double density() {return 0.00973;}
        /**
        * Returns the specific heat.
        * @return 0.09
        */
        public double specificHeat() {return 0.09;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0000364
        */
        public double thermalConductivity() {return 0.0000364;}
        /**
        * Returns the chemical symbol.
        * @return Rn
        */
        public String toString() {
                return new String("Rn");
        }
}

