package JSci.chemistry.periodictable;

/**
* A class representing rhenium.
* @version 1.5
* @author Mark Hale
*/
public final class Rhenium extends TransitionMetal {
        /**
        * Constructs rhenium.
        */
        public Rhenium() {}
        /**
        * Returns the atomic number.
        * @return 75
        */
        public int atomicNumber() {return 75;}
        /**
        * Returns the mass number.
        * @return 186
        */
        public int massNumber() {return 186;}
        /**
        * Returns the electronegativity.
        * @return 1.9
        */
        public double electronegativity() {return 1.9;}
        /**
        * Returns the covalent radius.
        * @return 1.28
        */
        public double covalentRadius() {return 1.28;}
        /**
        * Returns the atomic radius.
        * @return 1.97
        */
        public double atomicRadius() {return 1.97;}
        /**
        * Returns the melting point.
        * @return 3453.0
        */
        public double meltingPoint() {return 3453.0;}
        /**
        * Returns the boiling point.
        * @return 5869.0
        */
        public double boilingPoint() {return 5869.0;}
        /**
        * Returns the density (293K).
        * @return 21.0
        */
        public double density() {return 21.0;}
        /**
        * Returns the specific heat.
        * @return 0.13
        */
        public double specificHeat() {return 0.13;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0542e6
        */
        public double electricalConductivity() {return 0.0542e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.479
        */
        public double thermalConductivity() {return 0.479;}
        /**
        * Returns the chemical symbol.
        * @return Re
        */
        public String toString() {
                return new String("Re");
        }
}

