package JSci.chemistry.periodictable;

/**
* A class representing rhodium.
* @version 1.5
* @author Mark Hale
*/
public final class Rhodium extends TransitionMetal {
        /**
        * Constructs rhodium.
        */
        public Rhodium() {}
        /**
        * Returns the atomic number.
        * @return 45
        */
        public int atomicNumber() {return 45;}
        /**
        * Returns the mass number.
        * @return 103
        */
        public int massNumber() {return 103;}
        /**
        * Returns the electronegativity.
        * @return 2.28
        */
        public double electronegativity() {return 2.28;}
        /**
        * Returns the covalent radius.
        * @return 1.25
        */
        public double covalentRadius() {return 1.25;}
        /**
        * Returns the atomic radius.
        * @return 1.83
        */
        public double atomicRadius() {return 1.83;}
        /**
        * Returns the melting point.
        * @return 2236.0
        */
        public double meltingPoint() {return 2236.0;}
        /**
        * Returns the boiling point.
        * @return 3970.0
        */
        public double boilingPoint() {return 3970.0;}
        /**
        * Returns the density (293K).
        * @return 12.4
        */
        public double density() {return 12.4;}
        /**
        * Returns the specific heat.
        * @return 0.242
        */
        public double specificHeat() {return 0.242;}
        /**
        * Returns the electrical conductivity.
        * @return 0.211e6
        */
        public double electricalConductivity() {return 0.211e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.50
        */
        public double thermalConductivity() {return 1.50;}
        /**
        * Returns the chemical symbol.
        * @return Rh
        */
        public String toString() {
                return new String("Rh");
        }
}

