package JSci.chemistry.periodictable;

/**
* A class representing ruthenium.
* @version 1.5
* @author Mark Hale
*/
public final class Ruthenium extends TransitionMetal {
        /**
        * Constructs ruthenium.
        */
        public Ruthenium() {}
        /**
        * Returns the atomic number.
        * @return 44
        */
        public int atomicNumber() {return 44;}
        /**
        * Returns the mass number.
        * @return 101
        */
        public int massNumber() {return 101;}
        /**
        * Returns the electronegativity.
        * @return 2.2
        */
        public double electronegativity() {return 2.2;}
        /**
        * Returns the covalent radius.
        * @return 1.25
        */
        public double covalentRadius() {return 1.25;}
        /**
        * Returns the atomic radius.
        * @return 1.89
        */
        public double atomicRadius() {return 1.89;}
        /**
        * Returns the melting point.
        * @return 2523.0
        */
        public double meltingPoint() {return 2523.0;}
        /**
        * Returns the boiling point.
        * @return 4423.0
        */
        public double boilingPoint() {return 4423.0;}
        /**
        * Returns the density (293K).
        * @return 12.2
        */
        public double density() {return 12.2;}
        /**
        * Returns the specific heat.
        * @return 0.238
        */
        public double specificHeat() {return 0.238;}
        /**
        * Returns the electrical conductivity.
        * @return 0.137e6
        */
        public double electricalConductivity() {return 0.137e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.17
        */
        public double thermalConductivity() {return 1.17;}
        /**
        * Returns the chemical symbol.
        * @return Ru
        */
        public String toString() {
                return new String("Ru");
        }
}

