package JSci.chemistry.periodictable;

/**
* A class representing scandium.
* @version 1.5
* @author Mark Hale
*/
public final class Scandium extends TransitionMetal {
        /**
        * Constructs scandium.
        */
        public Scandium() {}
        /**
        * Returns the atomic number.
        * @return 21
        */
        public int atomicNumber() {return 21;}
        /**
        * Returns the mass number.
        * @return 45
        */
        public int massNumber() {return 45;}
        /**
        * Returns the electronegativity.
        * @return 1.36
        */
        public double electronegativity() {return 1.36;}
        /**
        * Returns the covalent radius.
        * @return 1.44
        */
        public double covalentRadius() {return 1.44;}
        /**
        * Returns the atomic radius.
        * @return 2.09
        */
        public double atomicRadius() {return 2.09;}
        /**
        * Returns the melting point.
        * @return 1812.0
        */
        public double meltingPoint() {return 1812.0;}
        /**
        * Returns the boiling point.
        * @return 3104.0
        */
        public double boilingPoint() {return 3104.0;}
        /**
        * Returns the density (293K).
        * @return 3.0
        */
        public double density() {return 3.0;}
        /**
        * Returns the specific heat.
        * @return 0.6
        */
        public double specificHeat() {return 0.6;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0177e6
        */
        public double electricalConductivity() {return 0.0177e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.158
        */
        public double thermalConductivity() {return 0.158;}
        /**
        * Returns the chemical symbol.
        * @return Sc
        */
        public String toString() {
                return new String("Sc");
        }
}

