package JSci.chemistry.periodictable;

/**
* A class representing silicon.
* @version 1.5
* @author Mark Hale
*/
public final class Silicon extends NonMetal {
        /**
        * Constructs silicon.
        */
        public Silicon() {}
        /**
        * Returns the atomic number.
        * @return 14
        */
        public int atomicNumber() {return 14;}
        /**
        * Returns the mass number.
        * @return 28
        */
        public int massNumber() {return 28;}
        /**
        * Returns the electronegativity.
        * @return 1.90
        */
        public double electronegativity() {return 1.90;}
        /**
        * Returns the covalent radius.
        * @return 1.17
        */
        public double covalentRadius() {return 1.17;}
        /**
        * Returns the atomic radius.
        * @return 1.46
        */
        public double atomicRadius() {return 1.46;}
        /**
        * Returns the melting point.
        * @return 1685.0
        */
        public double meltingPoint() {return 1685.0;}
        /**
        * Returns the boiling point.
        * @return 3540.0
        */
        public double boilingPoint() {return 3540.0;}
        /**
        * Returns the density (293K).
        * @return 2.33
        */
        public double density() {return 2.33;}
        /**
        * Returns the specific heat.
        * @return 0.71
        */
        public double specificHeat() {return 0.71;}
        /**
        * Returns the electrical conductivity.
        * @return 2.52e-6
        */
        public double electricalConductivity() {return 2.52e-6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.48
        */
        public double thermalConductivity() {return 1.48;}
        /**
        * Returns the chemical symbol.
        * @return Si
        */
        public String toString() {
                return new String("Si");
        }
}

