package JSci.chemistry.periodictable;

/**
* A class representing sodium.
* @version 1.5
* @author Mark Hale
*/
public final class Sodium extends AlkaliMetal {
        /**
        * Constructs sodium.
        */
        public Sodium() {}
        /**
        * Returns the atomic number.
        * @return 11
        */
        public int atomicNumber() {return 11;}
        /**
        * Returns the mass number.
        * @return 23
        */
        public int massNumber() {return 23;}
        /**
        * Returns the electronegativity.
        * @return 0.93
        */
        public double electronegativity() {return 0.93;}
        /**
        * Returns the covalent radius.
        * @return 1.57
        */
        public double covalentRadius() {return 1.57;}
        /**
        * Returns the atomic radius.
        * @return 2.23
        */
        public double atomicRadius() {return 2.23;}
        /**
        * Returns the melting point.
        * @return 371.0
        */
        public double meltingPoint() {return 371.0;}
        /**
        * Returns the boiling point.
        * @return 1156.0
        */
        public double boilingPoint() {return 1156.0;}
        /**
        * Returns the density (293K).
        * @return 0.971
        */
        public double density() {return 0.971;}
        /**
        * Returns the specific heat.
        * @return 1.23
        */
        public double specificHeat() {return 1.23;}
        /**
        * Returns the electrical conductivity.
        * @return 0.139e6
        */
        public double electricalConductivity() {return 0.139e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.41
        */
        public double thermalConductivity() {return 1.41;}
        /**
        * Returns the chemical symbol.
        * @return Na
        */
        public String toString() {
                return new String("Na");
        }
}

