package JSci.chemistry.periodictable;

/**
* A class representing sulphur.
* @version 1.5
* @author Mark Hale
*/
public final class Sulphur extends NonMetal {
        /**
        * Constructs sulphur.
        */
        public Sulphur() {}
        /**
        * Returns the atomic number.
        * @return 16
        */
        public int atomicNumber() {return 16;}
        /**
        * Returns the mass number.
        * @return 32
        */
        public int massNumber() {return 32;}
        /**
        * Returns the electronegativity.
        * @return 2.58
        */
        public double electronegativity() {return 2.58;}
        /**
        * Returns the covalent radius.
        * @return 1.04
        */
        public double covalentRadius() {return 1.04;}
        /**
        * Returns the atomic radius.
        * @return 1.09
        */
        public double atomicRadius() {return 1.09;}
        /**
        * Returns the melting point.
        * @return 388.36
        */
        public double meltingPoint() {return 388.36;}
        /**
        * Returns the boiling point.
        * @return 717.75
        */
        public double boilingPoint() {return 717.75;}
        /**
        * Returns the density (293K).
        * @return 2.07
        */
        public double density() {return 2.07;}
        /**
        * Returns the specific heat.
        * @return 0.71
        */
        public double specificHeat() {return 0.71;}
        /**
        * Returns the electrical conductivity.
        * @return 0.5e-17
        */
        public double electricalConductivity() {return 0.5e-17;}
        /**
        * Returns the thermal conductivity.
        * @return 0.00269
        */
        public double thermalConductivity() {return 0.00269;}
        /**
        * Returns the chemical symbol.
        * @return S
        */
        public String toString() {
                return new String("S");
        }
}

