package JSci.chemistry.periodictable;

/**
* A class representing tantalum.
* @version 1.5
* @author Mark Hale
*/
public final class Tantalum extends TransitionMetal {
        /**
        * Constructs tantalum.
        */
        public Tantalum() {}
        /**
        * Returns the atomic number.
        * @return 73
        */
        public int atomicNumber() {return 73;}
        /**
        * Returns the mass number.
        * @return 181
        */
        public int massNumber() {return 181;}
        /**
        * Returns the electronegativity.
        * @return 1.5
        */
        public double electronegativity() {return 1.5;}
        /**
        * Returns the covalent radius.
        * @return 1.34
        */
        public double covalentRadius() {return 1.34;}
        /**
        * Returns the atomic radius.
        * @return 2.09
        */
        public double atomicRadius() {return 2.09;}
        /**
        * Returns the melting point.
        * @return 3287.0
        */
        public double meltingPoint() {return 3287.0;}
        /**
        * Returns the boiling point.
        * @return 5731.0
        */
        public double boilingPoint() {return 5731.0;}
        /**
        * Returns the density (293K).
        * @return 16.6
        */
        public double density() {return 16.6;}
        /**
        * Returns the specific heat.
        * @return 0.14
        */
        public double specificHeat() {return 0.14;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0761e6
        */
        public double electricalConductivity() {return 0.0761e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.575
        */
        public double thermalConductivity() {return 0.575;}
        /**
        * Returns the chemical symbol.
        * @return Ta
        */
        public String toString() {
                return new String("Ta");
        }
}

