package JSci.chemistry.periodictable;

/**
* A class representing tellurium.
* @version 1.5
* @author Mark Hale
*/
public final class Tellurium extends NonMetal {
        /**
        * Constructs tellurium.
        */
        public Tellurium() {}
        /**
        * Returns the atomic number.
        * @return 52
        */
        public int atomicNumber() {return 52;}
        /**
        * Returns the mass number.
        * @return 128
        */
        public int massNumber() {return 128;}
        /**
        * Returns the electronegativity.
        * @return 2.1
        */
        public double electronegativity() {return 2.1;}
        /**
        * Returns the covalent radius.
        * @return 1.37
        */
        public double covalentRadius() {return 1.37;}
        /**
        * Returns the atomic radius.
        * @return 1.42
        */
        public double atomicRadius() {return 1.42;}
        /**
        * Returns the melting point.
        * @return 722.65
        */
        public double meltingPoint() {return 722.65;}
        /**
        * Returns the boiling point.
        * @return 1621.0
        */
        public double boilingPoint() {return 1621.0;}
        /**
        * Returns the density (293K).
        * @return 6.24
        */
        public double density() {return 6.24;}
        /**
        * Returns the specific heat.
        * @return 0.20
        */
        public double specificHeat() {return 0.20;}
        /**
        * Returns the electrical conductivity.
        * @return 2.0
        */
        public double electricalConductivity() {return 2.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0235
        */
        public double thermalConductivity() {return 0.0235;}
        /**
        * Returns the chemical symbol.
        * @return Te
        */
        public String toString() {
                return new String("Te");
        }
}

