package JSci.chemistry.periodictable;

/**
* A class representing thorium.
* @version 1.5
* @author Mark Hale
*/
public final class Thorium extends RareEarthMetal {
        /**
        * Constructs thorium.
        */
        public Thorium() {}
        /**
        * Returns the atomic number.
        * @return 90
        */
        public int atomicNumber() {return 90;}
        /**
        * Returns the mass number.
        * @return 232
        */
        public int massNumber() {return 232;}
        /**
        * Returns the electronegativity.
        * @return 1.3
        */
        public double electronegativity() {return 1.3;}
        /**
        * Returns the covalent radius.
        * @return 1.65
        */
        public double covalentRadius() {return 1.65;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 2028.0
        */
        public double meltingPoint() {return 2028.0;}
        /**
        * Returns the boiling point.
        * @return 5061.0
        */
        public double boilingPoint() {return 5061.0;}
        /**
        * Returns the density (293K).
        * @return 11.7
        */
        public double density() {return 11.7;}
        /**
        * Returns the specific heat.
        * @return 0.12
        */
        public double specificHeat() {return 0.12;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0653e6
        */
        public double electricalConductivity() {return 0.0653e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.540
        */
        public double thermalConductivity() {return 0.540;}
        /**
        * Returns the chemical symbol.
        * @return Th
        */
        public String toString() {
                return new String("Th");
        }
}

