package JSci.chemistry.periodictable;

/**
* A class representing thulium.
* @version 1.5
* @author Mark Hale
*/
public final class Thulium extends RareEarthMetal {
        /**
        * Constructs thulium.
        */
        public Thulium() {}
        /**
        * Returns the atomic number.
        * @return 69
        */
        public int atomicNumber() {return 69;}
        /**
        * Returns the mass number.
        * @return 169
        */
        public int massNumber() {return 169;}
        /**
        * Returns the electronegativity.
        * @return 1.25
        */
        public double electronegativity() {return 1.25;}
        /**
        * Returns the covalent radius.
        * @return 1.56
        */
        public double covalentRadius() {return 1.56;}
        /**
        * Returns the atomic radius.
        * @return 2.42
        */
        public double atomicRadius() {return 2.42;}
        /**
        * Returns the melting point.
        * @return 1818.0
        */
        public double meltingPoint() {return 1818.0;}
        /**
        * Returns the boiling point.
        * @return 2220.0
        */
        public double boilingPoint() {return 2220.0;}
        /**
        * Returns the density (293K).
        * @return 9.33
        */
        public double density() {return 9.33;}
        /**
        * Returns the specific heat.
        * @return 0.16
        */
        public double specificHeat() {return 0.16;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0150e6
        */
        public double electricalConductivity() {return 0.0150e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.168
        */
        public double thermalConductivity() {return 0.168;}
        /**
        * Returns the chemical symbol.
        * @return Tm
        */
        public String toString() {
                return new String("Tm");
        }
}

