package JSci.chemistry.periodictable;

/**
* A class representing tin.
* @version 1.5
* @author Mark Hale
*/
public final class Tin extends Metal {
        /**
        * Constructs tin.
        */
        public Tin() {}
        /**
        * Returns the atomic number.
        * @return 50
        */
        public int atomicNumber() {return 50;}
        /**
        * Returns the mass number.
        * @return 119
        */
        public int massNumber() {return 119;}
        /**
        * Returns the electronegativity.
        * @return 1.96
        */
        public double electronegativity() {return 1.96;}
        /**
        * Returns the covalent radius.
        * @return 1.40
        */
        public double covalentRadius() {return 1.40;}
        /**
        * Returns the atomic radius.
        * @return 1.72
        */
        public double atomicRadius() {return 1.72;}
        /**
        * Returns the melting point.
        * @return 505.06
        */
        public double meltingPoint() {return 505.06;}
        /**
        * Returns the boiling point.
        * @return 2876.0
        */
        public double boilingPoint() {return 2876.0;}
        /**
        * Returns the density (293K).
        * @return 7.30
        */
        public double density() {return 7.30;}
        /**
        * Returns the specific heat.
        * @return 0.227
        */
        public double specificHeat() {return 0.227;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0917e6
        */
        public double electricalConductivity() {return 0.0917e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.666
        */
        public double thermalConductivity() {return 0.666;}
        /**
        * Returns the chemical symbol.
        * @return Sn
        */
        public String toString() {
                return new String("Sn");
        }
}

