package JSci.chemistry.periodictable;

/**
* A class representing tungsten.
* @version 1.5
* @author Mark Hale
*/
public final class Tungsten extends TransitionMetal {
        /**
        * Constructs tungsten.
        */
        public Tungsten() {}
        /**
        * Returns the atomic number.
        * @return 74
        */
        public int atomicNumber() {return 74;}
        /**
        * Returns the mass number.
        * @return 184
        */
        public int massNumber() {return 184;}
        /**
        * Returns the electronegativity.
        * @return 2.36
        */
        public double electronegativity() {return 2.36;}
        /**
        * Returns the covalent radius.
        * @return 1.30
        */
        public double covalentRadius() {return 1.30;}
        /**
        * Returns the atomic radius.
        * @return 2.02
        */
        public double atomicRadius() {return 2.02;}
        /**
        * Returns the melting point.
        * @return 3680.0
        */
        public double meltingPoint() {return 3680.0;}
        /**
        * Returns the boiling point.
        * @return 5828.0
        */
        public double boilingPoint() {return 5828.0;}
        /**
        * Returns the density (293K).
        * @return 19.3
        */
        public double density() {return 19.3;}
        /**
        * Returns the specific heat.
        * @return 0.13
        */
        public double specificHeat() {return 0.13;}
        /**
        * Returns the electrical conductivity.
        * @return 0.189e6
        */
        public double electricalConductivity() {return 0.189e6;}
        /**
        * Returns the thermal conductivity.
        * @return 1.74
        */
        public double thermalConductivity() {return 1.74;}
        /**
        * Returns the chemical symbol.
        * @return W
        */
        public String toString() {
                return new String("W");
        }
}

