package JSci.chemistry.periodictable;

/**
* A class representing vanadium.
* @version 1.5
* @author Mark Hale
*/
public final class Vanadium extends TransitionMetal {
        /**
        * Constructs vanadium.
        */
        public Vanadium() {}
        /**
        * Returns the atomic number.
        * @return 23
        */
        public int atomicNumber() {return 23;}
        /**
        * Returns the mass number.
        * @return 51
        */
        public int massNumber() {return 51;}
        /**
        * Returns the electronegativity.
        * @return 1.63
        */
        public double electronegativity() {return 1.63;}
        /**
        * Returns the covalent radius.
        * @return 1.22
        */
        public double covalentRadius() {return 1.22;}
        /**
        * Returns the atomic radius.
        * @return 1.92
        */
        public double atomicRadius() {return 1.92;}
        /**
        * Returns the melting point.
        * @return 2175.0
        */
        public double meltingPoint() {return 2175.0;}
        /**
        * Returns the boiling point.
        * @return 3682.0
        */
        public double boilingPoint() {return 3682.0;}
        /**
        * Returns the density (293K).
        * @return 5.8
        */
        public double density() {return 5.8;}
        /**
        * Returns the specific heat.
        * @return 0.49
        */
        public double specificHeat() {return 0.49;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0489e6
        */
        public double electricalConductivity() {return 0.0489e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.307
        */
        public double thermalConductivity() {return 0.307;}
        /**
        * Returns the chemical symbol.
        * @return V
        */
        public String toString() {
                return new String("V");
        }
}

