package JSci.chemistry.periodictable;

/**
* A class representing xenon.
* @version 1.5
* @author Mark Hale
*/
public final class Xenon extends NobleGas {
        /**
        * Constructs xenon.
        */
        public Xenon() {}
        /**
        * Returns the atomic number.
        * @return 54
        */
        public int atomicNumber() {return 54;}
        /**
        * Returns the mass number.
        * @return 131
        */
        public int massNumber() {return 131;}
        /**
        * Returns the electronegativity.
        * @return 0.0
        */
        public double electronegativity() {return 0.0;}
        /**
        * Returns the covalent radius.
        * @return 1.31
        */
        public double covalentRadius() {return 1.31;}
        /**
        * Returns the atomic radius.
        * @return 1.24
        */
        public double atomicRadius() {return 1.24;}
        /**
        * Returns the melting point.
        * @return 161.36
        */
        public double meltingPoint() {return 161.36;}
        /**
        * Returns the boiling point.
        * @return 165.03
        */
        public double boilingPoint() {return 165.03;}
        /**
        * Returns the density (293K).
        * @return 0.00588
        */
        public double density() {return 0.00588;}
        /**
        * Returns the specific heat.
        * @return 0.158
        */
        public double specificHeat() {return 0.158;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0569e-3
        */
        public double thermalConductivity() {return 0.0569e-3;}
        /**
        * Returns the chemical symbol.
        * @return Xe
        */
        public String toString() {
                return new String("Xe");
        }
}

