package JSci.chemistry.periodictable;

/**
* A class representing yttrium.
* @version 1.5
* @author Mark Hale
*/
public final class Yttrium extends TransitionMetal {
        /**
        * Constructs yttrium.
        */
        public Yttrium() {}
        /**
        * Returns the atomic number.
        * @return 39
        */
        public int atomicNumber() {return 39;}
        /**
        * Returns the mass number.
        * @return 89
        */
        public int massNumber() {return 89;}
        /**
        * Returns the electronegativity.
        * @return 1.22
        */
        public double electronegativity() {return 1.22;}
        /**
        * Returns the covalent radius.
        * @return 1.62
        */
        public double covalentRadius() {return 1.62;}
        /**
        * Returns the atomic radius.
        * @return 2.27
        */
        public double atomicRadius() {return 2.27;}
        /**
        * Returns the melting point.
        * @return 1799.0
        */
        public double meltingPoint() {return 1799.0;}
        /**
        * Returns the boiling point.
        * @return 3611.0
        */
        public double boilingPoint() {return 3611.0;}
        /**
        * Returns the density (293K).
        * @return 4.47
        */
        public double density() {return 4.47;}
        /**
        * Returns the specific heat.
        * @return 0.3
        */
        public double specificHeat() {return 0.3;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0166e6
        */
        public double electricalConductivity() {return 0.0166e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.172
        */
        public double thermalConductivity() {return 0.172;}
        /**
        * Returns the chemical symbol.
        * @return Y
        */
        public String toString() {
                return new String("Y");
        }
}

