package JSci.io;

import JSci.maths.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;

/**
* The MathMLDocument class encapsulates an entire MathML document.
* @version 0.3
* @author Mark Hale
*/
public final class MathMLDocument extends DocumentImpl {
        /**
        * Constructs a MathML document.
        */
        public MathMLDocument() {
                super(null);
                appendChild(createElement("math"));
        }
        /**
        * Creates a MathML number element (&lt;cn&gt;).
        */
        public Element createNumber(double x) {
                final Element num=createElement("cn");
                num.appendChild(createTextNode(String.valueOf(x)));
                return num;
        }
        /**
        * Creates a MathML number element (&lt;cn&gt;).
        */
        public Element createNumber(int i) {
                final Element num=createElement("cn");
                num.setAttribute("type","integer");
                num.appendChild(createTextNode(String.valueOf(i)));
                return num;
        }
        /**
        * Creates a MathML number element (&lt;cn&gt;).
        */
        public Element createNumber(Complex z) {
                final Element num=createElement("cn");
                num.setAttribute("type","complex-cartesian");
                num.appendChild(createTextNode(String.valueOf(z.real())));
                num.appendChild(createElement("sep"));
                num.appendChild(createTextNode(String.valueOf(z.imag())));
                return num;
        }
        /**
        * Creates a MathML symbol element (&lt;ci&gt;).
        */
        public Element createSymbol(Object o) {
                final Element sym=createElement("ci");
                sym.appendChild(createTextNode(o.toString()));
                return sym;
        }
        /**
        * Creates a MathML vector element (&lt;vector&gt;).
        */
        public Element createVector(DoubleVector v) {
                final Element vector=createElement("vector");
                for(int i=0;i<v.dimension();i++)
                        vector.appendChild(createNumber(v.getComponent(i)));
                return vector;
        }
        /**
        * Creates a MathML vector element (&lt;vector&gt;).
        */
        public Element createVector(IntegerVector v) {
                final Element vector=createElement("vector");
                for(int i=0;i<v.dimension();i++)
                        vector.appendChild(createNumber(v.getComponent(i)));
                return vector;
        }
        /**
        * Creates a MathML vector element (&lt;vector&gt;).
        */
        public Element createVector(ComplexVector v) {
                final Element vector=createElement("vector");
                for(int i=0;i<v.dimension();i++)
                        vector.appendChild(createNumber(v.getComponent(i)));
                return vector;
        }
        /**
        * Creates a MathML matrix element (&lt;matrix&gt;).
        */
        public Element createMatrix(DoubleMatrix m) {
                final Element matrix=createElement("matrix");
                Element row;
                for(int j,i=0;i<m.rows();i++) {
                        row=createElement("matrixrow");
                        for(j=0;j<m.columns();j++)
                                row.appendChild(createNumber(m.getElement(i,j)));
                        matrix.appendChild(row);
                }
                return matrix;
        }
        /**
        * Creates a MathML matrix element (&lt;matrix&gt;).
        */
        public Element createMatrix(IntegerMatrix m) {
                final Element matrix=createElement("matrix");
                Element row;
                for(int j,i=0;i<m.rows();i++) {
                        row=createElement("matrixrow");
                        for(j=0;j<m.columns();j++)
                                row.appendChild(createNumber(m.getElement(i,j)));
                        matrix.appendChild(row);
                }
                return matrix;
        }
        /**
        * Creates a MathML matrix element (&lt;matrix&gt;).
        */
        public Element createMatrix(ComplexMatrix m) {
                final Element matrix=createElement("matrix");
                Element row;
                for(int j,i=0;i<m.rows();i++) {
                        row=createElement("matrixrow");
                        for(j=0;j<m.columns();j++)
                                row.appendChild(createNumber(m.getElement(i,j)));
                        matrix.appendChild(row);
                }
                return matrix;
        }
        /**
        * Creates a MathML set element (&lt;set&gt;).
        */
        public Element createSet(DiscreteSet s) {
                final Element set=createElement("set");
                for(int i=0;i<s.size();i++)
                        set.appendChild(createSymbol(s.getElement(i)));
                return set;
        }
        /**
        * Creates a MathML operator/function element (&lt;apply&gt;).
        */
        public Element createApply(String name,DocumentFragment args) {
                final Element apply=createElement("apply");
                apply.appendChild(createElement(name));
                apply.appendChild(args);
                return apply;
        }
        /**
        * Creates a MathML relation element (&lt;reln&gt;).
        */
        public Element createReln(String name,DocumentFragment args) {
                final Element reln=createElement("reln");
                reln.appendChild(createElement(name));
                reln.appendChild(args);
                return reln;
        }
}

