package JSci.maths;

/**
* The DiscreteSet class provides an encapsulation for discrete sets.
* @version 1.2
* @author Mark Hale
*/
public class DiscreteSet extends Object implements MathSet {
        private String label;
        /**
        * The set elements.
        */
        protected Object elements[];
        /**
        * Constructs a discrete set.
        * @param aLabel a label that identifies this set
        */
        protected DiscreteSet(String aLabel) {
                label=aLabel;
        }
        /**
        * Constructs a discrete set.
        * @param aLabel a label that identifies this set
        * @param array an array containing the set elements
        */
        public DiscreteSet(String aLabel,Object array[]) {
                this(aLabel);
                elements=new Object[array.length];
                System.arraycopy(array,0,elements,0,array.length);
        }
        /**
        * Compares two sets for equality.
        */
        public boolean equals(Object s) {
                return (s!=null) && (s instanceof DiscreteSet) && label.equals(s.toString());
        }
        /**
        * Returns a string representing this set.
        */
        public final String toString() {
                return label;
        }
        /**
        * Returns the number of elements in the set.
        */
        public final int size() {
                return elements.length;
        }
        /**
        * Returns an element from within the set.
        * @param n index of the element
        */
        public final Object getElement(int n) {
                return elements[n];
        }
        /**
        * Performs the union of this set with another.
        * @param set a discrete set
        * @return the union of the two sets
        */
        public MathSet union(MathSet set) {
                if(!(set instanceof DiscreteSet))
                        throw new IllegalArgumentException("Must be a discrete set.");
                final DiscreteSet s=(DiscreteSet)set;
                boolean unique;
                int k;
                Object uObj[],tempObj[]=new Object[elements.length+s.size()];
                if(elements.length>s.size()) {
                        for(k=0;k<s.size();k++)
                                tempObj[k]=s.getElement(k);
                        for(int i=0;i<elements.length;i++) {
                                unique=true;
                                for(int j=0;j<s.size();j++) {
                                        if(elements[i].equals(tempObj[j]))
                                                unique=false;
                                }
                                if(unique)
                                        tempObj[k++]=elements[i];
                        }
                } else {
                        for(k=0;k<elements.length;k++)
                                tempObj[k]=elements[k];
                        for(int i=0;i<s.size();i++) {
                                unique=true;
                                for(int j=0;j<elements.length;j++) {
                                        if(s.getElement(i).equals(tempObj[j]))
                                                unique=false;
                                }
                                if(unique)
                                        tempObj[k++]=s.getElement(i);
                        }
                }
                uObj=new Object[k];
                System.arraycopy(tempObj,0,uObj,0,uObj.length);
                return new DiscreteSet("("+toString()+") U ("+s.toString()+")",uObj);
        }
        /**
        * Performs the intersection of this set with another.
        * @param set a discrete set
        * @return the intersection of the two sets
        */
        public MathSet intersect(MathSet set) {
                if(!(set instanceof DiscreteSet))
                        throw new IllegalArgumentException("Must be a discrete set.");
                final DiscreteSet s=(DiscreteSet)set;
                boolean unique;
                int k=0;
                Object tempObj[],iObj[];
                if(elements.length>s.size()) {
                        tempObj=new Object[elements.length];
                        for(int i=0;i<elements.length;i++) {
                                unique=true;
                                for(int j=0;j<s.size() && unique;j++) {
                                        if(elements[i].equals(s.getElement(j))) {
                                                tempObj[k++]=elements[i];
                                                unique=false;
                                        }
                                }
                        }
                } else {
                        tempObj=new Object[s.size()];
                        for(int i=0;i<s.size();i++) {
                                unique=true;
                                for(int j=0;j<elements.length && unique;j++) {
                                        if(s.getElement(i).equals(elements[j])) {
                                                tempObj[k++]=elements[j];
                                                unique=false;
                                        }
                                }
                        }
                }
                iObj=new Object[k];
                System.arraycopy(tempObj,0,iObj,0,iObj.length);
                return new DiscreteSet("("+toString()+") I ("+s.toString()+")",iObj);
        }
}

