package JSci.maths;

/**
* The Matrix superclass provides an abstract encapsulation for matrices.
* @version 2.1
* @author Mark Hale
*/
public abstract class Matrix extends Object implements AlgebraMember, java.io.Serializable {
        /**
        * Storage format identifier.
        */
        protected final static int CLASS_SPECIFIC=0;
        protected final static int storageFormat=CLASS_SPECIFIC;
        /**
        * Constructs a matrix.
        */
        public Matrix() {}
        /**
        * Returns the number of rows.
        */
        public abstract int rows();
        /**
        * Returns the number of columns.
        */
        public abstract int columns();
        /**
        * Returns the transpose of this matrix.
        */
        public abstract Matrix transpose();
}

